Option Explicit
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' Plik:          vbsWaitForProcess.vbs
' Aktualizacja:  Listopad 2002
' Wersja:        1.0
' Autor:         Dan Thomson, felietonista myITforum.com
'                Jestem dostpny pod adresem dethomson@hotmail.com
'
' Zastosowanie:  Naley uruchomi procesor polece za pomoc cscript
'                cscript vbsWaitForProcess.vbs notepad.exe 60 S
'                lub
'                Wersje IE i Popup mona uruchomi za pomoc cscript lub wscript
'                wscript vbsWaitForProcess.vbs notepad.exe -1
'
' Parematry we:  Nazwa programu  (np.: notepad.exe)
'                Czas oczekiwania w sekundach przed zakoczeniem programu
'                -1 oczekiwanie na zakoczenie procesu w nieskoczono
'                0 natychmiast koczy proces
'                Dowolna warto > 0 spowoduje, e skrypt bdzie oczekiwa
'                okrelon liczb sekund przed zakoczeniem procesu
'           Tryb bez komunikatw  (S)
'
' Uwagi:
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

On Error Resume Next

'Zdefiniowanie zmiennych
Dim strProcess
Dim intWaitTime
Dim strSilent

'Pobranie argumentw wiersza polecenia
strProcess = Wscript.Arguments.Item(0)
intWaitTime = CInt(Wscript.Arguments.Item(1))
strSilent = Wscript.Arguments.Item(2)

Call WaitForProcess (strProcess, intWaitTime, strSilent)

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' Funkcja:        ProcessIsRunning
'
' Przeznaczenie:  Sprawdza, czy proces dziaa
'
' Parametr we:    Nazwa procesu
'
' Wynik:          True lub False w zalenoci od tego, czy proces dziaa
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Private Function ProcessIsRunning( strProcess )
    Dim colProcessList

    Set colProcessList = Getobject("Winmgmts:").Execquery _
        ("Select * from Win32_Process Where Name ='" & strProcess & "'")
    If colProcessList.Count > 0 Then
        ProcessIsRunning = True
    Else
        ProcessIsRunning = False
    End If

    Set colProcessList = Nothing
End Function

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' Funkcja:          TerminateProcess
'
' Przeznaczenie:    Koczy proces
'
' Parametr we:      Nazwa procesu
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Private Function ProcessTerminate( strProcess )
    Dim colProcessList, objProcess

    Set colProcessList = GetObject("Winmgmts:").ExecQuery _
        ("Select * from Win32_Process Where Name ='" & strProcess & "'")
    For Each objProcess in colProcessList
        objProcess.Terminate( )
    Next

    Set colProcessList = Nothing
End Function

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' Procedura:      WaitForProcess
'
' Przeznaczenie:  Oczekiwanie na proces
'
' Parametry we:   Nazwa procesu
'                 Czas oczekiwania w sekundach przed zakoczeniem procesu.
'                 -1 spowoduje oczekiwanie w nieskoczono
'                 0 spowoduje natychmiastowe zakoczenie procesu
'                 Kada warto > 0 spowoduje, e skrypt bdzie czeka
'                 okrelon liczb sekund przed zakoczeniem procesu
'             Tryb wywietlania.
'                 Parametr S spowoduje dziaanie w trybie bez wywietlania komunikatw
'
' Wynik:      Status wywietlany na ekranie
'
' Uwagi:      Niniejsza wersja wywietla komunikaty w oknie za pomoc StdOut
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Private Sub WaitForProcess( strProcess, intWaitTime, strMode )

  If ProcessIsRunning(strProcess) Then
    Dim objIntExplorer
    Dim c : c = 0
    Dim w : w = 0
    Dim strPrompt
    Dim intPause : intPause = 1

    strPrompt = "Oczekiwanie na zakoczenie " & strProcess & "."

    ' Utworzenie odwoania do objIntExplorer, jeli komunikaty nie zostay wyczone
    'Ustawienia komunikatw uytkownika - atrybuty wywietlania przegldarki IE
    If UCase(strMode) <> "S" Then
      Set objIntExplorer = Wscript._
      CreateObject("InternetExplorer.Application")
      With objIntExplorer
        .Navigate "about:blank"
        .ToolBar = 0
        .Menubar = 0         ' bez menu
        .StatusBar = 0
        .Width=400
        .Height = 80
        .Left = 100
        .Top = 100
        .Document.Title = "WaitForProcess"
      End With
      'Oczekiwanie na zakoczenie przegldarki IE
      Do While (objIntExplorer.Busy)
          Wscript.Sleep 200
      Loop
      'Wywietlenie IE
      objIntExplorer.Visible = 1
    End If
    Do While ProcessIsRunning(strProcess)
      'Sprawdzenie, czy upyna okrelona liczba sekund przed zakoczeniem
      'procesu. Jeli tak - zakoczenie procesu
      If w >= intWaitTime AND intWaitTime >= 0 Then
        Call ProcessTerminate(strProcess)
        Exit Do
      End If
      If UCase(strMode) <> "S" Then
        objIntExplorer.Document.Body.InnerHTML = strPrompt & String(c, ".")
        'Inkrementacja licznika.
        'Zresetowanie wskanika licznika jeli jest > 25 aby
        'nie zajmowa zbyt duo miejsca na ekranie.
        If c > 25 Then c = 1 Else c = c + 1
        'Inkrementacja licznika sekund
        w = w + intPause
      End If
      'Pauza
      Wscript.Sleep(intPause * 1000)
    Loop
    objIntExplorer.Quit( )             ' zamknicie Internet Explorera
    Set objIntExplorer = Nothing       ' zwolnienie odwoania do obiektu

  End If
End Sub
